<div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Cài đặt</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">×</span>
            </button>
        </div>
        <form action="{{ route('user.limit', $token) }}" method="post" enctype="multipart/form-data" id="setting_form">
            @csrf
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="form-control-label">Cài đặt số lượt để xóa</label> <br>
                            <div class="input-group limit-err">
                                <span class="input-group-text"><i class="fa fa-quidditch"></i></span>
                                <input name="limit" id="limit" value="{{ $user->limit }}" type="number" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-control-label" for="basic-url">Chọn user chuyển data</label>
                            <select class="form-control" id="move_file" name="move_file">
                                <option value="">{{ $user->name }}</option>
                                @foreach ($users as $us)
                                    @if($us->user_token == $user->move_file)
                                        <option value="{{ $us->user_token }}" selected>{{ $us->name }}</option>
                                    @elseif($us->user_token != $token)
                                        <option value="{{ $us->user_token }}">{{ $us->name }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="form-control-label">Get random</label> <br>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="get_random" @if($user->get_random == 0) checked @endif value="0" id="customRadio1">
                                <label class="custom-control-label" for="customRadio1">Lấy cũ nhất</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="get_random" @if($user->get_random == 1) checked @endif value="1" id="customRadio2">
                                <label class="custom-control-label" for="customRadio2">Lấy random</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="get_random" @if($user->get_random == 2) checked @endif value="2" id="customRadio3">
                                <label class="custom-control-label" for="customRadio3">Lấy mới nhất</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="form-control-label">Thống kê</label> <br>
                            <div class="form-check">
                                <input class="form-check-input" name="total" type="checkbox" @if($user->total == 1) checked @endif id="total">
                                <label class="custom-control-label" for="customCheck1">Tích chọn tính tổng xu</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn bg-gradient-success submit">Cập nhật</button>
            </div>
        </form>
    </div>
</div>
<script>
    $('#setting_form').submit(function(e){
        e.preventDefault();
        $('.submit').attr('disabled', true);
        var url = $('form#setting_form').attr('action');
        var limit = $("#limit").val();
        var move_file = $("#move_file").val();
        var get_random = 0;
        var total = 0;
        if ($('#customRadio2').is(":checked")){
            get_random = 1;
        }else if($('#customRadio3').is(":checked")){
            get_random = 2;
        }
        if ($('#total').is(":checked")){
            total = 1;
        }
        $.ajax({
            url: url,
            type: "post",
            data: {
                _token: "{{ csrf_token() }}",
                limit: limit,
                get_random: get_random,
                move_file: move_file,
                total: total
            },
            success: function(response) {
                if(response.success == true){
                    Swal.fire({
                        icon: 'success',
                        title: 'Cập nhật thành công',
                        showConfirmButton: true,
                    }).then((result) => {
                    if (result.isConfirmed) {
                        $('.submit').removeAttr('disabled');
                        window.location.reload();
                        }
                    })
                }
            },
            error: function(err) {
                if (err.status == 422) {
                    $('#limit-error').html('');
                    $.each(JSON.parse(err.responseText)['errors'], function(i, error) {
                        $(document).find('.limit-err').after($('<span id="limit-error" class="error" for="limit-error" style="color:red">' + error + '</span>'));
                    });
                }
                $('.submit').attr('disabled', false);
            }
        });
    });

    $('#total').change(function() {
        if ($(this).is(':checked')) {
            $.ajax({
                url: "{{ route('checkNumber') }}",
                type: "get",
                data: {
                    token: "{{ $token }}"
                },
                success: function(response) {
                    $(this).is(':checked')
                },
                error: function(err) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Dữ liệu là chuỗi không thể tính tổng',
                        showConfirmButton: false,
                        timer: 2500
                    })
                }
            });
        }
    });
</script>
