@extends('admin.master')
@section('style')
<style>
.td_nowrap {
    min-width:100px;
    max-width:200px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space:nowrap
}
</style>
@endsection
@section('content')
<main class="main-content position-relative max-height-vh-100 h-100 mt-1 border-radius-lg ">
    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none border-radius-xl" id="navbarBlur"
        navbar-scroll="true">
        <div class="container-fluid py-1 px-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb bg-transparent mb-0 pb-0 pt-1 px-0 me-sm-6 me-5">
                    <li class="breadcrumb-item text-sm"><a class="opacity-5 text-dark" href="javascript:;">Home</a>
                    </li>
                    <li class="breadcrumb-item text-sm text-dark active" aria-current="page">Data</li>
                </ol>
                <h6 class="font-weight-bolder mb-0">Data @if($user->role != 1)- Thành viên: {{ $user->name }} - {{ $user->email }} @endif</h6>
                {{-- <b>Tổng số data: {{ number_format($count) }}</b> --}}
            </nav>
        @include('admin.info')
        </div>
    </nav>
    <!-- End Navbar -->
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header pb-0">
                        @if (session('information'))
                            <div class="alert alert-{{ session('information') }}"><b>{{ session('messege') }}</b></div>
                        @endif
                    </div><br>
                    <div class="card-body px-0 pt-0 pb-2">
                        <div class="table-responsive p-0">
                            <table class="table table-flush" id="datatable-basic">
                                <thead class="thead-light">
                                    <tr>
                                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder">#</th>
                                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder">Data</th>
                                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder">Ngày</th>
                                        {{-- <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder">Trạng thái</th> --}}
                                        <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder">
                                            <a href="javascript:;" class="text-secondary font-weight-bold text-xs restore_all">
                                                <span class="badge bg-gradient-success">Khôi phục tất cả</span>
                                            </a>||
                                            <a href="javascript:;" class="text-secondary font-weight-bold text-xs delete_all">
                                                <span class="badge bg-gradient-danger">Xoá vĩnh viễn</span>
                                            </a>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody id="tbody">
                                    @php
                                        $i = 1;
                                    @endphp
                                    @if(isset($datas))
                                    @foreach($datas as $data)
                                    <tr>
                                        <td class="align-middle text-center text-sm">
                                            <p class="text-xs font-weight-bold mb-0">{{ $i++ }}</p>
                                        </td>
                                        <td class="align-middle text-center text-sm td_nowrap">
                                            <p class="text-xs font-weight-bold mb-0">{{ $data->data }}
                                                @if($data->file_path)
                                                + <a href="{{ url('uploads/'.$data->file_path) }}">{{ explode('/', $data->file_path)[1] }}</a>
                                                @endif
                                            </p>
                                        </td>
                                        <td class="align-middle text-center text-sm">
                                            <p class="text-xs font-weight-bold mb-0">{{ date('H:i d/m/Y', strtotime(str_replace('/', '-', $data->deleted_at))) }}</p>
                                        </td>
                                        <td class="align-middle text-center">
                                            <a href="javascript:;" restore_id="{{ $data->id }}" class="text-secondary font-weight-bold text-xs restore" >
                                                <span class="badge bg-gradient-success">Khôi phục</span>
                                            </a>
                                            ||
                                            <a href="javascript:;" delete_id="{{ $data->id }}" class="text-secondary font-weight-bold text-xs simpleConfirm">
                                                <span class="badge bg-gradient-danger">Xoá</span>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        <div class="pagination justify-content-end">
                            {{ $datas->links('vendor.pagination.bootstrap-4') }}
                          </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
@endsection
@section('script')
<script src="{{ asset('dashboard/assets/js/plugins/datatables.js') }}" type="text/javascript"></script>
<script type="text/javascript">
    $(document).ready(function () {
      var msg = "{{Session::get('message')}}";
      var exist = "{{Session::has('message')}}";
        if (exist && msg == '1') {
        Swal.fire({
              icon: 'success',
              title: 'Cập nhật thành công!',
              showConfirmButton: false,
              timer: 2500
          })
        }
    })

    $(document).on('click', '.simpleConfirm', function(e) {
        e.preventDefault();
        var id = $(this).attr('delete_id');
        var that = $(this);
        swal.fire({
            title: "Bạn có muốn xóa dữ liệu này?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Xóa ngay!',
            cancelButtonText: 'Hủy'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    method: 'get',
                    url: "{{ route('data.permanentlyDelete') }}",
                    data: {
                        id: id,
                        user_token: '{{ $token }}'
                    },
                    success: function(data) {
                        if (data.success == true) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Xóa thành công',
                                showConfirmButton: true
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.reload();
                                }
                            })
                        }
                    }
                })
            }
        });
    });

    $(document).on('click', '.restore', function(e) {
        e.preventDefault();
        var id = $(this).attr('restore_id');
        var that = $(this);
        swal.fire({
            title: "Bạn muốn khôi phục dữ liệu này?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Khôi phục!',
            cancelButtonText: 'Hủy'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    method: 'get',
                    url: "{{ route('data.restore') }}",
                    data: {
                        id: id,
                        user_token: '{{ $token }}'
                    },
                    success: function(data) {
                        if (data.success == true) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Khôi phục thành công',
                                showConfirmButton: true
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.reload();
                                }
                            })
                        }
                    }
                })
            }
        });
    });

    $(document).on('click', '.delete_all', function(e) {
        e.preventDefault();
        var that = $(this);
        swal.fire({
            title: "Bạn có muốn xóa tất cả dữ liệu này?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Xóa ngay!',
            cancelButtonText: 'Hủy'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    method: 'get',
                    url: "{{ route('data.permanentlyDeleteAll') }}",
                    data: {
                        user_token: '{{ $token }}'
                    },
                    success: function(data) {
                        console.log(data);
                        if (data.success == true) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Xóa thành công',
                                showConfirmButton: true,
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.reload();
                                }
                            })
                        }
                    }
                })
            }
        });
    });

    $(document).on('click', '.restore_all', function(e) {
        e.preventDefault();
        var that = $(this);
        swal.fire({
            title: "Bạn muốn khôi phục tất cả dữ liệu này?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'khôi phục!',
            cancelButtonText: 'Hủy'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    method: 'get',
                    url: "{{ route('data.restoreAll') }}",
                    data: {
                        user_token: '{{ $token }}'
                    },
                    success: function(data) {
                        console.log(data);
                        if (data.success == true) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Khôi phục thành công',
                                showConfirmButton: true,
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.reload();
                                }
                            })
                        }
                    }
                })
            }
        });
    });
</script>
@endsection
